#include <iostream>
#include <vector>
#include <set>
using namespace std;

int izracunaj_trosak(const vector<int>& niz, int n) {
    int trosak = 0;
    for (int i = 0; i < n - 1; i++) {
        if (niz[i] > niz[i + 1]) {
            trosak++;
        }
    }
    return trosak + 1; // Dodajemo 1 za osnovni slucaj
}

void azuriraj_greske(set<int>& greske, const vector<int>& niz, int i, int n) {
    if (i > 0 && i < n - 1) {
        if (niz[i - 1] > niz[i]) {
            greske.insert(i - 1);
        } else {
            greske.erase(i - 1);
        }
    }
    if (i >= 0 && i < n - 1) {
        if (niz[i] > niz[i + 1]) {
            greske.insert(i);
        } else {
            greske.erase(i);
        }
    }
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);

    int n, broj_upita;
    cin >> n >> broj_upita;

    vector<int> niz(n);
    for (int i = 0; i < n; i++) {
        cin >> niz[i];
    }

    set<int> greske;
    for (int i = 0; i < n - 1; i++) {
        if (niz[i] > niz[i + 1]) {
            greske.insert(i);
        }
    }

    cout << greske.size() + 1 << "\n";

    while (broj_upita--) {
        int i, j;
        cin >> i >> j;
        i--, j--;

        azuriraj_greske(greske, niz, i, n);
        azuriraj_greske(greske, niz, j, n);

        swap(niz[i], niz[j]);

        azuriraj_greske(greske, niz, i, n);
        azuriraj_greske(greske, niz, j, n);

        cout << greske.size() + 1 << "\n";
    }

    return 0;
}